package kom.itbeankit.common.itbeanframe;


/*************************************************************************************
 * This interface declares the methods that will be invoked if an
 * ItBeanControlEvent occurs.
 * @see kom.itbeankit.common.itbeanframe.ItBeanControlEvent
 * @author: Abdulmotaleb El Saddik, Christian C. Hoffmann
 * @version 0.5  26.06.1998
 *
*/

public interface ItBeanFrameListener extends java.util.EventListener {

    /**
    This method will be invoked if an ItBeanFrameEvent with the id NEW_FILE occurs.
    */
    public void newFile(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id STOP occurs.
    */
    public void stop(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id PLAY occurs.
    */
    public void play(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id PAUSE occurs.
    */
    public void pause(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id HIDE occurs.
    */
    public void hide(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id BACKWARDS occurs.
    */
    public void backwards(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id FORWARDS occurs.
    */
    public void forwards(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id TO_BEGIN occurs.
    */
    public void toBegin(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id OPEN_URL occurs.
    */
    public void openURL(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id SAVE occurs.
    */
    public void save(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id SAVE_AS occurs.
    */
    public void saveAs(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id EXIT occurs.
    */
    public void exit(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id LEVEL_CHANGED occurs.
    */
    public void levelUp(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id LEVEL_CHANGED occurs.
    */
    public void levelDown(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id LANGUAGE_CHANGED occurs.
    */
    public void languageChanged(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id EXPLANATION_CHANGED occurs.
    */
    public void explanationChanged(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id GUIDED_TOUR occurs.
    */
    public void guidedTour(ItBeanFrameEvent e);

    /**
    This method will be invoked if an ItBeanFrameEvent with the id ABOUT occurs.
    */
    public void about(ItBeanFrameEvent e);

}

